/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.utils;

public class DistributionHelpers {
    public static final float PI = (float)Math.PI;

    public static float[] getTriangularDistribution(int midY, int range, float maxChance) {
        return DistributionHelpers.getTriangularDistribution(midY - range, range, range, maxChance);
    }

    public static float[] getTriangularDistribution(int minY, int rand1, int rand2, float maxChance) {
        float[] triangle = new float[rand1 + rand2 + 1];
        float modChance = maxChance / (float)Math.min(rand1, rand2);
        for (int i = 0; i < rand1; ++i) {
            for (int j = 0; j < rand2; ++j) {
                int n = i + j;
                triangle[n] = triangle[n] + modChance;
            }
        }
        float[] result = new float[256];
        for (int i = 0; i < triangle.length; ++i) {
            int mapToPos = i + minY;
            if (mapToPos < 0) continue;
            if (mapToPos == result.length) break;
            result[mapToPos] = triangle[i];
        }
        return result;
    }

    public static float[] getSquareDistribution(int minY, int maxY, float chance) {
        float[] result = new float[256];
        for (int i = minY; i <= maxY; ++i) {
            result[i] = chance;
        }
        return result;
    }

    public static float[] getRoundedSquareDistribution(int min0, int minY, int maxY, int max0, float chance) {
        float[] result = new float[256];
        DistributionHelpers.addDistribution(result, DistributionHelpers.getRampDistribution(min0, minY, chance), min0);
        DistributionHelpers.addDistribution(result, DistributionHelpers.getSquareDistribution(minY, maxY, chance));
        DistributionHelpers.addDistribution(result, DistributionHelpers.getRampDistribution(max0, maxY, chance), maxY);
        return result;
    }

    public static float[] getUnderwaterDistribution(float chance) {
        float[] result = DistributionHelpers.getTriangularDistribution(47, 8, chance / 7.0f);
        DistributionHelpers.addDistribution(result, DistributionHelpers.getRampDistribution(57, 62, chance), 57);
        result[62] = chance;
        DistributionHelpers.addDistribution(result, DistributionHelpers.getTriangularDistribution(55, 4, chance / 3.0f));
        return result;
    }

    public static float[] getRampDistribution(int minY, int maxY, float maxChance) {
        if (minY == maxY) {
            return new float[0];
        }
        if (minY > maxY) {
            return DistributionHelpers.reverse(DistributionHelpers.getRampDistribution(maxY, minY, maxChance));
        }
        int range = maxY - minY;
        float[] result = new float[range + 1];
        for (int i = 0; i < range; ++i) {
            result[i] = maxChance * (float)i / (float)range;
        }
        return result;
    }

    public static float[] getOverworldSurfaceDistribution(int oreDiameter) {
        float[] result = new float[256];
        float[] triangularDist = DistributionHelpers.getOverworldSurface();
        float chance = (float)oreDiameter / 256.0f;
        for (int i = 0; i < result.length - oreDiameter && i != triangularDist.length; ++i) {
            if (triangularDist[i] == 0.0f) continue;
            for (int j = 0; j < oreDiameter; ++j) {
                int n = i + j;
                result[n] = result[n] + triangularDist[i] * chance;
            }
        }
        return result;
    }

    public static float[] getOverworldSurface() {
        return DistributionHelpers.getTriangularDistribution(69, 5, 0.09090909f);
    }

    public static float[] addDistribution(float[] base, float[] add) {
        return DistributionHelpers.addDistribution(base, add, 0);
    }

    public static float[] addDistribution(float[] base, float[] add, int offset) {
        int addCount = 0;
        int i = offset;
        while (i < Math.min(base.length, add.length + offset)) {
            int n = i++;
            base[n] = base[n] + add[addCount++];
        }
        return base;
    }

    public static float[] reverse(float[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[array.length - 1 - i] = array[i];
        }
        return result;
    }

    public static int calculateMeanLevel(float[] distribution, int mid, int oldMid, float difference) {
        float totalUp = 0.0f;
        float totalDown = 0.0f;
        for (int i = 0; i < distribution.length; ++i) {
            if (i < mid) {
                totalDown += distribution[i];
                continue;
            }
            totalUp += distribution[i];
        }
        float newDifference = totalUp - totalDown;
        if (Math.abs(difference + newDifference) <= Math.abs(newDifference)) {
            if (Math.abs(newDifference) < Math.abs(difference)) {
                return mid;
            }
            return oldMid;
        }
        if (newDifference > 0.0f) {
            return DistributionHelpers.calculateMeanLevel(distribution, mid + 1, mid, newDifference);
        }
        return DistributionHelpers.calculateMeanLevel(distribution, mid - 1, mid, newDifference);
    }

    public static float[] divideArray(float[] array, float num) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] / num;
        }
        return result;
    }

    public static float[] multiplyArray(float[] array, float num) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * num;
        }
        return result;
    }

    public static float[] maxJoinArray(float[] array1, float[] array2) {
        float[] result = new float[array1.length];
        if (array1.length != array2.length) {
            return result;
        }
        for (int i = 0; i < array1.length; ++i) {
            result[i] = Math.max(array1[i], array2[i]);
        }
        return result;
    }

    public static float sum(float[] distribution) {
        float result = 0.0f;
        for (float val : distribution) {
            result += val;
        }
        return result;
    }
}

