/*
 * Decompiled with CFR 0.152.
 */
package neresources.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import neresources.api.utils.conditionals.Conditional;
import neresources.config.Settings;
import neresources.entries.OreMatchEntry;
import neresources.reference.Resources;
import neresources.registry.OreRegistry;
import neresources.utils.Font;
import neresources.utils.RenderHelper;
import neresources.utils.TranslationHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class NEIOreHandler
extends TemplateRecipeHandler {
    private static final int X_OFFSPRING = 59;
    private static final int Y_OFFSPRING = 52;
    private static final int X_AXIS_SIZE = 90;
    private static final int Y_AXIS_SIZE = 40;
    private static final int X_ITEM = 8;
    private static final int Y_ITEM = 6;
    private static int CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);

    public static void reloadSettings() {
        CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);
    }

    public String getGuiTexture() {
        return Resources.Gui.Nei.ORE.toString();
    }

    public String getRecipeName() {
        return TranslationHelper.translateToLocal("ner.ore.title");
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(60, -12, 45, 10), "neresources.ore", new Object[]{new Object()}));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("neresources.ore")) {
            for (OreMatchEntry entry : OreRegistry.getOres()) {
                this.arecipes.add(new CachedOre(entry));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (OreMatchEntry entry : OreRegistry.getRegistryMatches(result)) {
            if (entry == null) continue;
            this.arecipes.add(new CachedOre(entry));
        }
    }

    public void drawExtras(int recipe) {
        RenderHelper.drawArrow(59.0, 52.0, 149.0, 52.0, -7829368);
        RenderHelper.drawArrow(59.0, 52.0, 59.0, 12.0, -7829368);
        CachedOre cachedOre = (CachedOre)((Object)this.arecipes.get(recipe));
        float[] array = cachedOre.oreMatchEntry.getChances();
        double max = 0.0;
        float[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double d = arr$[i$];
            if (!(d > max)) continue;
            max = d;
        }
        double xPrev = 59.0;
        double yPrev = 52.0;
        double space = 90.0 / ((double)(array.length - 1) * 1.0);
        for (int i = 0; i < array.length; ++i) {
            double value = array[i];
            double y = 52.0 - value / max * 40.0;
            if (i > 0) {
                double x = xPrev + space;
                RenderHelper.drawLine(xPrev, yPrev, x, y, cachedOre.getLineColor());
                xPrev = x;
            }
            yPrev = y;
        }
        Font.small.print("0%", 49, 45);
        Font.small.print(String.format("%.2f", max * 100.0) + "%", 39, 12);
        int minY = cachedOre.oreMatchEntry.getMinY() - Settings.EXTRA_RANGE;
        Font.small.print(minY < 0 ? 0 : minY, 56, 54);
        int maxY = cachedOre.oreMatchEntry.getMaxY() + Settings.EXTRA_RANGE;
        Font.small.print(maxY > 255 ? 255 : maxY, 149, 54);
        Font.small.print(TranslationHelper.translateToLocal("ner.ore.bestY") + ": " + cachedOre.oreMatchEntry.getBestY(), 6, 26);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)gui) && currenttip.size() == 0) {
            Point offset = gui.getRecipePosition(recipe);
            Point pos = GuiDraw.getMousePosition();
            Point relMouse = new Point(pos.x - gui.field_147003_i - offset.x, pos.y - gui.field_147009_r - offset.y);
            if (relMouse.x > 59 && relMouse.x < 149 && relMouse.y > 12 && relMouse.y < 52) {
                CachedOre cachedOre = (CachedOre)((Object)this.arecipes.get(recipe));
                float[] chances = cachedOre.oreMatchEntry.getChances();
                double space = 90.0 / ((double)chances.length * 1.0);
                int index = (int)((double)(relMouse.x - 59) / space);
                int yValue = Math.max(0, index + cachedOre.oreMatchEntry.getMinY() - Settings.EXTRA_RANGE + 1);
                if (index >= 0 && index < chances.length) {
                    currenttip.add("Y: " + yValue + String.format(" (%.2f%%)", Float.valueOf(chances[index] * 100.0f)));
                }
            }
        }
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedOre cachedOre = (CachedOre)((Object)this.arecipes.get(recipe));
        if (stack != null && cachedOre.contains(stack)) {
            if (cachedOre.oreMatchEntry.isSilkTouchNeeded(stack)) {
                currenttip.add(Conditional.silkTouch.toString());
            }
            if (gui.isMouseOver(cachedOre.getResult(), recipe)) {
                currenttip.addAll(cachedOre.getRestrictions());
            }
        }
        return currenttip;
    }

    public class CachedOre
    extends TemplateRecipeHandler.CachedRecipe {
        private OreMatchEntry oreMatchEntry;
        private List<ItemStack> oresAndDrops;

        public CachedOre(OreMatchEntry oreMatchEntry) {
            super((TemplateRecipeHandler)NEIOreHandler.this);
            this.oreMatchEntry = oreMatchEntry;
            this.oresAndDrops = oreMatchEntry.getOresAndDrops();
        }

        public PositionedStack getResult() {
            int index = NEIOreHandler.this.cycleticks / CYCLE_TIME % this.oresAndDrops.size();
            return new PositionedStack((Object)this.oresAndDrops.get(index), 8, 6);
        }

        public int getLineColor() {
            return this.oreMatchEntry.getColour();
        }

        public List<String> getRestrictions() {
            return this.oreMatchEntry.getRestrictions();
        }

        public boolean contains(ItemStack itemStack) {
            for (ItemStack listStack : this.oresAndDrops) {
                if (!listStack.func_77969_a(itemStack)) continue;
                return true;
            }
            return false;
        }
    }
}

