/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.tiles;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import mrtjp.projectred.api.IBundledTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileWireConnector;
import unwrittenfun.minecraft.immersiveintegration.wires.IIWires;
import unwrittenfun.minecraft.immersiveintegration.wires.RedstoneWireNetwork;

public class TileRedstoneWireConnector
extends TileWireConnector
implements IBundledTile,
IEBlockInterfaces.IBlockOverlayText {
    public static final String[] UNLOC_COLORS = new String[]{"white", "orange", "magenta", "lightBlue", "yellow", "lime", "pink", "grey", "lightGrey", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final int NUM_CHANNELS = 16;
    public boolean redstoneMode = false;
    public int redstoneChannel = 0;
    public RedstoneWireNetwork wireNetwork = new RedstoneWireNetwork().add(this);
    private boolean loaded = false;

    public void func_145845_h() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.loaded) {
            this.loaded = true;
            this.wireNetwork.removeFromNetwork(null);
        }
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        return super.canConnectCable(cableType, target);
    }

    public WireType getCableLimiter(TargetingInfo target) {
        return IIWires.redstoneWire;
    }

    public void toggleMode() {
        this.redstoneMode = !this.redstoneMode;
        this.wireNetwork.updateValues();
        this.wireNetwork.notifyOfChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void writeCustomNBT(NBTTagCompound compound, boolean descPacket) {
        super.writeCustomNBT(compound, descPacket);
        compound.func_74757_a("redstoneMode", this.redstoneMode);
        compound.func_74768_a("redstoneChannel", this.redstoneChannel);
    }

    public void readCustomNBT(NBTTagCompound compound, boolean descPacket) {
        super.readCustomNBT(compound, descPacket);
        this.redstoneMode = compound.func_74767_n("redstoneMode");
        this.redstoneChannel = compound.func_74762_e("redstoneChannel");
    }

    public void incrementChannel() {
        ++this.redstoneChannel;
        if (this.redstoneChannel >= 16) {
            this.redstoneChannel = 0;
        }
        this.wireNetwork.updateValues();
        this.wireNetwork.notifyOfChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String getChannelName() {
        return StatCollector.func_74838_a((String)("immersiveintegration.color." + UNLOC_COLORS[this.redstoneChannel]));
    }

    public boolean isOutput() {
        return !this.redstoneMode;
    }

    public boolean isInput() {
        return this.redstoneMode;
    }

    public int getPowerOutput() {
        return this.wireNetwork.getPowerOutput(this.redstoneChannel);
    }

    @Override
    public void connectTo(int x, int y, int z) {
        TileEntity tileEntity = this.field_145850_b.func_147438_o(x, y, z);
        if (tileEntity instanceof TileRedstoneWireConnector) {
            TileRedstoneWireConnector wireConnector = (TileRedstoneWireConnector)tileEntity;
            if (wireConnector.wireNetwork != this.wireNetwork) {
                this.wireNetwork.mergeNetwork(wireConnector.wireNetwork);
            }
        }
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        this.wireNetwork.removeFromNetwork(this);
    }

    @Override
    public int getRenderRadiusIncrease() {
        return IIWires.redstoneWire.getMaxLength();
    }

    @Override
    public boolean canConnectBundled(int side) {
        return true;
    }

    @Override
    public byte[] getBundledSignal(int dir) {
        return this.isInput() ? null : this.wireNetwork.getByteValues();
    }

    public String[] getOverlayText(MovingObjectPosition mop) {
        return new String[]{StatCollector.func_74838_a((String)"immersiveintegration.chat.channel") + " " + this.getChannelName(), StatCollector.func_74838_a((String)"immersiveintegration.chat.mode") + " " + (this.redstoneMode ? "Input" : "Output")};
    }
}

