/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.lwjgl.opengl.GL11;

public class CustomSky {
    private static CustomSkyLayer[][] worldSkyLayers = null;

    public static void reset() {
        worldSkyLayers = null;
    }

    public static void update() {
        CustomSky.reset();
        if (!Config.isCustomSky()) {
            return;
        }
        worldSkyLayers = CustomSky.readCustomSkies();
    }

    private static CustomSkyLayer[][] readCustomSkies() {
        CustomSkyLayer[][] wsls = new CustomSkyLayer[10][0];
        String prefix = "mcpatcher/sky/world";
        int lastWorldId = -1;
        for (int w2 = 0; w2 < wsls.length; ++w2) {
            String worldPrefix = prefix + w2 + "/sky";
            ArrayList<CustomSkyLayer> listSkyLayers = new ArrayList<CustomSkyLayer>();
            for (int i2 = 1; i2 < 1000; ++i2) {
                String path = worldPrefix + i2 + ".properties";
                try {
                    bqx locPath = new bqx(path);
                    InputStream in = Config.getResourceStream(locPath);
                    if (in == null) break;
                    Properties props = new Properties();
                    props.load(in);
                    Config.dbg("CustomSky properties: " + path);
                    String defSource = worldPrefix + i2 + ".png";
                    CustomSkyLayer sl = new CustomSkyLayer(props, defSource);
                    if (!sl.isValid(path)) continue;
                    bqx locSource = new bqx(sl.source);
                    bqh tex = TextureUtils.getTexture(locSource);
                    if (tex == null) {
                        Config.log("CustomSky: Texture not found: " + locSource);
                        continue;
                    }
                    sl.textureId = tex.b();
                    listSkyLayers.add(sl);
                    in.close();
                    continue;
                }
                catch (FileNotFoundException e2) {
                    break;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (listSkyLayers.size() <= 0) continue;
            CustomSkyLayer[] sls = listSkyLayers.toArray(new CustomSkyLayer[listSkyLayers.size()]);
            wsls[w2] = sls;
            lastWorldId = w2;
        }
        if (lastWorldId < 0) {
            return null;
        }
        int worldCount = lastWorldId + 1;
        CustomSkyLayer[][] wslsTrim = new CustomSkyLayer[worldCount][0];
        for (int i3 = 0; i3 < wslsTrim.length; ++i3) {
            wslsTrim[i3] = wsls[i3];
        }
        return wslsTrim;
    }

    public static void renderSky(ahb world, bqf re, float celestialAngle, float rainBrightness) {
        if (worldSkyLayers == null) {
            return;
        }
        if (Config.getGameSettings().c < 8) {
            return;
        }
        int dimId = world.t.i;
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return;
        }
        long time = world.J();
        int timeOfDay = (int)(time % 24000L);
        for (int i2 = 0; i2 < sls.length; ++i2) {
            CustomSkyLayer sl = sls[i2];
            if (!sl.isActive(timeOfDay)) continue;
            sl.render(timeOfDay, celestialAngle, rainBrightness);
        }
        CustomSky.clearBlend(rainBrightness);
    }

    public static boolean hasSkyLayers(ahb world) {
        if (worldSkyLayers == null) {
            return false;
        }
        if (Config.getGameSettings().c < 8) {
            return false;
        }
        int dimId = world.t.i;
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return false;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return false;
        }
        return sls.length > 0;
    }

    private static void clearBlend(float rainBrightness) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rainBrightness);
    }
}

