/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import com.google.gson.JsonObject;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties._MobPropertiesMod;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;
import toast.mobProperties.entry.NBTStatsInfo;
import toast.mobProperties.entry.PropertyGroup;

public class PropertyGroupConditional
extends PropertyGroup {
    private static Method worldDifficultyMethod;
    private final boolean inverted;
    private final String category;

    public static boolean isCategoryActive(boolean invert, String category, EntityLivingBase entity) {
        return PropertyGroupConditional.isCategoryActive(invert, category, entity, null, 0, false, false, false);
    }

    public static boolean isCategoryActive(boolean invert, String category, EntityLivingBase entity, DamageSource source, int looting, boolean recentlyHit, boolean rare, boolean superRare) {
        if (category.equals("recently_hit")) {
            return recentlyHit != invert;
        }
        if (category.equals("rare")) {
            return rare != invert;
        }
        if (category.equals("rare_super")) {
            return superRare != invert;
        }
        if (category.startsWith("above_looting_")) {
            try {
                return looting > Integer.parseInt(category.substring(14)) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (source != null && category.startsWith("killed_by_")) {
            try {
                return ((Class)EntityList.field_75625_b.get(category.substring(10))).isAssignableFrom(source.func_76346_g().getClass()) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("on_ground")) {
            return entity.field_70122_E != invert;
        }
        if (category.equals("burning")) {
            return entity.func_70027_ad() != invert;
        }
        if (category.equals("wet")) {
            return entity.func_70026_G() != invert;
        }
        if (category.equals("submerged")) {
            return (entity.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)entity)) != invert;
        }
        if (category.startsWith("has_potion_")) {
            try {
                return entity.func_70644_a(FileHelper.readPotion(category.substring(11), entity.getClass().getName(), true)) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.startsWith("check_nbt_")) {
            try {
                String[] path = category.substring(10).split("/");
                String[] data = PropertyGroupConditional.getOperatorData(path[path.length - 1]);
                path[path.length - 1] = data[0];
                return PropertyGroupConditional.compareNBT((Entity)entity, path, data) != invert;
            }
            catch (Exception path) {
                return invert;
            }
        }
        if (category.equals("wither_skeleton")) {
            return (entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_82202_m() == 1) != invert;
        }
        if (category.equals("raining")) {
            return entity.field_70170_p.func_72896_J() != invert;
        }
        if (category.equals("thundering")) {
            return entity.field_70170_p.func_72911_I() != invert;
        }
        if (category.equals("can_see_sky")) {
            return entity.field_70170_p.func_72937_j((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u), (int)Math.floor(entity.field_70161_v)) != invert;
        }
        if (category.startsWith("moon_phase_")) {
            return entity.field_70170_p.field_73011_w.func_76559_b(entity.field_70170_p.func_72820_D()) == PropertyGroupConditional.getMoonPhaseId(category.substring(11)) != invert;
        }
        if (category.startsWith("beyond_")) {
            try {
                double distance = Double.parseDouble(category.substring(7));
                ChunkCoordinates spawnPoint = entity.field_70170_p.func_72861_E();
                return entity.func_70092_e((double)spawnPoint.field_71574_a, (double)spawnPoint.field_71572_b, (double)spawnPoint.field_71573_c) > distance * distance != invert;
            }
            catch (Exception distance) {
                return invert;
            }
        }
        if (category.startsWith("difficulty_")) {
            return entity.field_70170_p.field_73013_u == PropertyGroupConditional.getDifficulty(category.substring(11)) != invert;
        }
        if (category.startsWith("past_world_difficulty_")) {
            try {
                long difficulty = (long)(Double.parseDouble(category.substring(22)) * 24000.0);
                if (worldDifficultyMethod != null) {
                    return (Long)worldDifficultyMethod.invoke(null, new Object[0]) > difficulty != invert;
                }
                category = "past_world_time_" + difficulty;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("past_day_time_")) {
            try {
                return (int)(entity.field_70170_p.func_72912_H().func_76073_f() % 24000L) > Integer.parseInt(category.substring(14)) != invert;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("past_world_time_")) {
            try {
                return entity.field_70170_p.func_72912_H().func_76073_f() > Long.parseLong(category.substring(16)) != invert;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("in_dimension_")) {
            try {
                return entity.field_71093_bK == Integer.parseInt(category.substring(13)) != invert;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("in_biome_")) {
            try {
                return entity.field_70170_p.func_72807_a((int)((int)Math.floor((double)entity.field_70165_t)), (int)((int)Math.floor((double)entity.field_70161_v))).field_76756_M == Integer.parseInt(category.substring(9)) != invert;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("on_block_")) {
            try {
                Block block = FileHelper.readBlock(category.substring(9), entity.getClass().getName(), true);
                int x = (int)Math.floor(entity.field_70165_t);
                int yMin = (int)Math.floor(entity.field_70163_u) - 1;
                int yMax = (int)Math.floor(entity.field_70163_u) + (int)Math.floor(entity.field_70131_O);
                int z = (int)Math.floor(entity.field_70161_v);
                for (int y = yMin; y <= yMax; ++y) {
                    if (entity.field_70170_p.func_147439_a(x, y, z) == block == invert) continue;
                    return true;
                }
                return invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.startsWith("below_")) {
            try {
                return (int)entity.field_70163_u < Integer.parseInt(category.substring(6)) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.startsWith("player_online_")) {
            try {
                return entity.field_70170_p.func_72924_a(category.substring(14)) != null != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        throw new RuntimeException("[ERROR] Conditional property has invalid condition! for " + entity.getClass().getName());
    }

    private static String[] getOperatorData(String last) {
        String[] operators;
        for (String operator : operators = new String[]{"==", ">", "<", ">=", "<="}) {
            String[] split = last.split(operator, 2);
            if (split.length != 2) continue;
            return new String[]{split[0], operator, split[1]};
        }
        return new String[]{last, null, null};
    }

    private static boolean compareNBT(Entity entity, String[] path, String[] data) {
        double value;
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_70109_d(tag);
        for (String pathStep : path) {
            if (tag instanceof NBTTagCompound) {
                if (!tag.func_74764_b(pathStep)) {
                    tag = null;
                    break;
                }
                tag = tag.func_74781_a(pathStep);
                continue;
            }
            if (tag instanceof NBTTagList) {
                int index = Integer.parseInt(pathStep);
                if (((NBTTagList)tag).func_74745_c() <= index) {
                    tag = null;
                    break;
                }
                tag = ((NBTTagList)tag).func_74744_a(index);
                continue;
            }
            return false;
        }
        if (data[1] == null) {
            return tag != null && ((NBTBase.NBTPrimitive)tag).func_150290_f() == 1;
        }
        try {
            value = Double.parseDouble(data[2]);
        }
        catch (NumberFormatException ex) {
            return data[1].equals("==") && data[2].equals(((NBTTagString)tag).func_150285_a_());
        }
        double actual = tag == null ? 0.0 : ((NBTBase.NBTPrimitive)tag).func_150286_g();
        if (data[1].equals("==")) {
            return actual == value;
        }
        if (data[1].equals(">")) {
            return actual > value;
        }
        if (data[1].equals("<")) {
            return actual < value;
        }
        if (data[1].equals(">=")) {
            return actual >= value;
        }
        if (data[1].equals("<=")) {
            return actual <= value;
        }
        return false;
    }

    private static int getMoonPhaseId(String phase) {
        if (phase.equalsIgnoreCase("FULL")) {
            return 0;
        }
        if (phase.equalsIgnoreCase("WANING_GIBBOUS")) {
            return 1;
        }
        if (phase.equalsIgnoreCase("THIRD_QUARTER") || phase.equalsIgnoreCase("WANING_HALF")) {
            return 2;
        }
        if (phase.equalsIgnoreCase("WANING_CRESCENT")) {
            return 3;
        }
        if (phase.equalsIgnoreCase("NEW")) {
            return 4;
        }
        if (phase.equalsIgnoreCase("WAXING_CRESCENT")) {
            return 5;
        }
        if (phase.equalsIgnoreCase("FIRST_QUARTER") || phase.equalsIgnoreCase("WAXING_HALF")) {
            return 6;
        }
        if (phase.equalsIgnoreCase("WAXING_GIBBOUS")) {
            return 7;
        }
        try {
            return Integer.parseInt(phase) % 8;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private static EnumDifficulty getDifficulty(String id) {
        if (id.equalsIgnoreCase("PEACEFUL")) {
            return EnumDifficulty.PEACEFUL;
        }
        if (id.equalsIgnoreCase("EASY")) {
            return EnumDifficulty.EASY;
        }
        if (id.equalsIgnoreCase("NORMAL")) {
            return EnumDifficulty.NORMAL;
        }
        if (id.equalsIgnoreCase("HARD")) {
            return EnumDifficulty.HARD;
        }
        try {
            return EnumDifficulty.func_151523_a((int)Integer.parseInt(id));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public PropertyGroupConditional(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader, String function, boolean invert) {
        super(path, root, index, node, loader);
        this.inverted = invert;
        this.category = function;
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, mobStats.theEntity)) {
            super.init(mobStats);
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        if (itemStats.parent instanceof MobDropsInfo) {
            MobDropsInfo mobDrops = (MobDropsInfo)itemStats.parent;
            if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, mobDrops.theEntity, mobDrops.theSource, mobDrops.looting, mobDrops.recentlyHit, mobDrops.rare, mobDrops.superRare)) {
                super.modifyItem(itemStats);
            }
        } else if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, itemStats.theEntity)) {
            super.modifyItem(itemStats);
        }
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        if (nbtStats.parent instanceof MobDropsInfo) {
            MobDropsInfo mobDrops = (MobDropsInfo)nbtStats.parent;
            if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, mobDrops.theEntity, mobDrops.theSource, mobDrops.looting, mobDrops.recentlyHit, mobDrops.rare, mobDrops.superRare)) {
                super.addTags(nbtStats);
            }
        } else if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, nbtStats.theEntity)) {
            super.addTags(nbtStats);
        }
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, mobDrops.theEntity, mobDrops.theSource, mobDrops.looting, mobDrops.recentlyHit, mobDrops.rare, mobDrops.superRare)) {
            super.modifyDrops(mobDrops);
        }
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        StringBuffer condition = new StringBuffer("");
        if (this.inverted) {
            condition.append("!");
        }
        condition.append("if_");
        condition.append(this.category);
        conditions.add(condition.toString());
        super.addDrops(dropsList, attempts, chance, conditions);
    }

    static {
        try {
            worldDifficultyMethod = Class.forName("toast.apocalypse.WorldDifficultyManager").getMethod("getWorldDifficulty", new Class[0]);
            _MobPropertiesMod.console("Successfully hooked into Apocalypse's world difficulty!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

