/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.drops;

import com.google.gson.JsonObject;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.drops.Schematic;

public class EntryDropsSchematic
extends EntryAbstract {
    private static final HashMap<String, Schematic> SCHEMATIC_MAP = new HashMap();
    private final String schematicName;
    private final byte update;
    private final double[] offsetsX;
    private final double[] offsetsY;
    private final double[] offsetsZ;
    private final byte blockOverride;
    private final byte airOverride;

    public static void unload() {
        SCHEMATIC_MAP.clear();
    }

    public static void load(String path, String fileName, NBTTagCompound tag) {
        String name = fileName.substring(0, fileName.length() - ".schematic".length());
        if (SCHEMATIC_MAP.containsKey(name)) {
            throw new MobPropertyException("Duplicate schematic name! (name: " + name + ")", path);
        }
        SCHEMATIC_MAP.put(name, new Schematic(tag));
    }

    public EntryDropsSchematic(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.schematicName = FileHelper.readText(node, path, "file", "");
        if (this.schematicName == "") {
            throw new MobPropertyException("Missing or invalid schematic file name!", path);
        }
        this.update = (byte)FileHelper.readInteger(node, path, "update", 3);
        this.offsetsX = FileHelper.readCounts(node, path, "x", Double.NaN, Double.NaN);
        this.offsetsY = FileHelper.readCounts(node, path, "y", 0.0, 0.0);
        this.offsetsZ = FileHelper.readCounts(node, path, "z", Double.NaN, Double.NaN);
        String text = FileHelper.readText(node, path, "override", "true");
        if (text.equals("true")) {
            this.blockOverride = 1;
        } else if (text.equals("false")) {
            this.blockOverride = 0;
        } else if (text.equals("replaceable")) {
            this.blockOverride = (byte)2;
        } else {
            throw new MobPropertyException("Invalid override value! (must be true, false, or replaceable)", path);
        }
        text = FileHelper.readText(node, path, "air_override", "replaceable");
        if (text.equals("true")) {
            this.airOverride = 1;
        } else if (text.equals("false")) {
            this.airOverride = 0;
        } else if (text.equals("replaceable")) {
            this.airOverride = (byte)2;
        } else {
            throw new MobPropertyException("Invalid air override value! (must be true, false, or replaceable)", path);
        }
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"file"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"update", "x", "y", "z", "override", "air_override"};
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        if (!mobDrops.theEntity.field_70170_p.field_72995_K) {
            Schematic schematic = SCHEMATIC_MAP.get(this.schematicName);
            if (schematic != null) {
                int x = (int)Math.floor(mobDrops.theEntity.field_70165_t);
                x = Double.isNaN(this.offsetsX[0]) ? (x -= schematic.getXSize() >> 1) : (x += FileHelper.getCount(this.offsetsX));
                int y = (int)Math.floor(mobDrops.theEntity.field_70163_u) + FileHelper.getCount(this.offsetsY);
                int z = (int)Math.floor(mobDrops.theEntity.field_70161_v);
                z = Double.isNaN(this.offsetsZ[0]) ? (z -= schematic.getZSize() >> 1) : (z += FileHelper.getCount(this.offsetsZ));
                schematic.place(mobDrops.theEntity.field_70170_p, x, y, z, this.update, this.blockOverride, this.airOverride);
            } else {
                super.modifyDrops(mobDrops);
            }
        }
    }
}

