/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.drops;

import com.google.gson.JsonObject;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.NBTStats;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobDropsInfo;

public class EntryDropsSetBlock
extends EntryAbstract {
    private final Block block;
    private final double[] blockData;
    private final byte update;
    private final double[] offsetsX;
    private final double[] offsetsY;
    private final double[] offsetsZ;
    private final NBTStats nbtStats;
    private final byte override;

    public EntryDropsSetBlock(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.block = FileHelper.readBlock(node, path, "id");
        this.blockData = FileHelper.readCounts(node, path, "data", 0.0, 0.0);
        this.update = (byte)FileHelper.readInteger(node, path, "update", 3);
        this.offsetsX = FileHelper.readCounts(node, path, "x", 0.0, 0.0);
        this.offsetsY = FileHelper.readCounts(node, path, "y", 0.0, 0.0);
        this.offsetsZ = FileHelper.readCounts(node, path, "z", 0.0, 0.0);
        this.nbtStats = new NBTStats(path, root, index, node, loader);
        String text = FileHelper.readText(node, path, "override", "replaceable");
        if (text.equals("true")) {
            this.override = 1;
        } else if (text.equals("false")) {
            this.override = 0;
        } else if (text.equals("replaceable")) {
            this.override = (byte)2;
        } else {
            throw new MobPropertyException("Invalid override value! (must be true, false, or replaceable)", path);
        }
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"id"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"data", "update", "x", "y", "z", "override", "tags"};
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        if (!mobDrops.theEntity.field_70170_p.field_72995_K) {
            TileEntity tileEntity;
            Block blockReplacing;
            int x = (int)Math.floor(mobDrops.theEntity.field_70165_t) + FileHelper.getCount(this.offsetsX);
            int y = (int)Math.floor(mobDrops.theEntity.field_70163_u) + FileHelper.getCount(this.offsetsY);
            int z = (int)Math.floor(mobDrops.theEntity.field_70161_v) + FileHelper.getCount(this.offsetsZ);
            int data = FileHelper.getCount(this.blockData);
            if (!(this.override == 1 || (blockReplacing = mobDrops.theEntity.field_70170_p.func_147439_a(x, y, z)) == Blocks.field_150350_a || this.override != 0 && blockReplacing.func_149688_o().func_76222_j())) {
                return;
            }
            mobDrops.theEntity.field_70170_p.func_147465_d(x, y, z, this.block, data, (int)this.update);
            if (this.nbtStats.hasEntries() && (tileEntity = mobDrops.theEntity.field_70170_p.func_147438_o(x, y, z)) != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tileEntity.func_145841_b(tag);
                this.nbtStats.generate(mobDrops.theEntity, tag, mobDrops);
                tileEntity.func_145839_a(tag);
            }
        }
    }
}

