/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.stats;

import com.google.gson.JsonObject;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.ItemStats;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobStatsInfo;

public class EntryStatsEquip
extends EntryAbstract {
    public final boolean override;
    public final int slot;
    public final double[] dropChances;
    public final Item item;
    public final double[] damages;
    public final double[] counts;
    public final ItemStats itemStats;

    public EntryStatsEquip(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.override = FileHelper.readBoolean(node, path, "override", false);
        this.slot = FileHelper.readInteger(node, path, "slot", 0);
        if (this.slot < 0 || this.slot > 4) {
            throw new MobPropertyException("Invalid slot! (" + this.slot + ": 0=hand, 1=legs, 2=body, 3=chest, 4=head)", path);
        }
        this.dropChances = FileHelper.readCounts(node, path, "drop_chance", 0.085, 0.085);
        this.item = FileHelper.readItem(node, path, "id", false);
        this.damages = FileHelper.readCounts(node, path, "damage", 0.0, 0.0);
        this.counts = FileHelper.readCounts(node, path, "count", 1.0, 1.0);
        this.itemStats = new ItemStats(path, root, index, node, loader);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"id"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"override", "slot", "drop_chance", "damage", "count", "item_stats"};
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        if (this.item == null) {
            return;
        }
        int count = FileHelper.getCount(this.counts, mobStats.random);
        if (count > 0) {
            int damage = FileHelper.getCount(this.damages, mobStats.random);
            ItemStack equipment = this.itemStats.generate(mobStats.theEntity, this.item, damage, mobStats);
            equipment.field_77994_a = count;
            if (equipment.func_77973_b() != null && (this.override || mobStats.theEntity.func_71124_b(this.slot) == null)) {
                mobStats.theEntity.func_70062_b(this.slot, equipment);
                if (mobStats.theEntity instanceof EntityLiving) {
                    float dropChance = (float)FileHelper.getValue(this.dropChances, mobStats.random);
                    ((EntityLiving)mobStats.theEntity).func_96120_a(this.slot, dropChance);
                }
            }
        } else if (this.override && count < 0) {
            mobStats.theEntity.func_70062_b(this.slot, (ItemStack)null);
        }
    }
}

