/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.asm.Hooks;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.ASMHelper;
import squeek.asmhelper.InsnComparator;
import squeek.asmhelper.ObfHelper;

public class ModuleBlockFood
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.block.BlockCake"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean isObfuscated = !name.equals(transformedName);
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "b" : "func_150036_b", isObfuscated ? "(Lahb;IIILyz;)V" : "(Lnet/minecraft/world/World;IIILnet/minecraft/entity/player/EntityPlayer;)V");
        if (methodNode != null) {
            this.addOnBlockFoodEatenHook(classNode, methodNode, isObfuscated);
            return ASMHelper.writeClassToBytes(classNode);
        }
        throw new RuntimeException("BlockCake: eatCakeSlice (func_150036_b) method not found");
    }

    private void addOnBlockFoodEatenHook(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        AbstractInsnNode ifCanEat = ASMHelper.findFirstInstructionWithOpcode(method, 153);
        if (ifCanEat == null) {
            throw new RuntimeException("IFEQ instruction not found in " + classNode.name + "." + method.name);
        }
        LabelNode ifEndLabel = ((JumpInsnNode)ifCanEat).label;
        InsnList toInject = new InsnList();
        AbstractInsnNode targetNode = ASMHelper.findNextInstruction(ifCanEat);
        LabelNode modifiedFoodValuesStart = new LabelNode();
        LocalVariableNode modifiedFoodValues = new LocalVariableNode("modifiedFoodValues", Type.getDescriptor(FoodValues.class), null, modifiedFoodValuesStart, ifEndLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(modifiedFoodValues);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 5));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "onBlockFoodEaten", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;)Lsqueek/applecore/api/food/FoodValues;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, modifiedFoodValues.index));
        toInject.add((AbstractInsnNode)modifiedFoodValuesStart);
        LabelNode prevFoodLevelStart = new LabelNode();
        LocalVariableNode prevFoodLevel = new LocalVariableNode("prevFoodLevel", "I", null, prevFoodLevelStart, ifEndLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(prevFoodLevel);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 5));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), isObfuscated ? "bQ" : "getFoodStats", isObfuscated ? "()Lzr;" : "()Lnet/minecraft/util/FoodStats;"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.util.FoodStats"), isObfuscated ? "a" : "getFoodLevel", "()I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(54, prevFoodLevel.index));
        toInject.add((AbstractInsnNode)prevFoodLevelStart);
        LabelNode prevSaturationLevelStart = new LabelNode();
        LocalVariableNode prevSaturationLevel = new LocalVariableNode("prevSaturationLevel", "F", null, prevSaturationLevelStart, ifEndLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(prevSaturationLevel);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 5));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), isObfuscated ? "bQ" : "getFoodStats", isObfuscated ? "()Lzr;" : "()Lnet/minecraft/util/FoodStats;"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.util.FoodStats"), isObfuscated ? "e" : "getSaturationLevel", "()F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(56, prevSaturationLevel.index));
        toInject.add((AbstractInsnNode)prevSaturationLevelStart);
        method.instructions.insertBefore(targetNode, toInject);
        InsnList hungerNeedle = new InsnList();
        hungerNeedle.add((AbstractInsnNode)new InsnNode(5));
        InsnList hungerReplacement = new InsnList();
        hungerReplacement.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        hungerReplacement.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(FoodValues.class), "hunger", "I"));
        InsnList saturationNeedle = new InsnList();
        saturationNeedle.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.1f)));
        InsnList saturationReplacement = new InsnList();
        saturationReplacement.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        saturationReplacement.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(FoodValues.class), "saturationModifier", "F"));
        ASMHelper.findAndReplace(method.instructions, hungerNeedle, hungerReplacement, targetNode);
        ASMHelper.findAndReplace(method.instructions, saturationNeedle, saturationReplacement, targetNode);
        AbstractInsnNode targetNodeAfter = ASMHelper.find(targetNode, (AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.world.World"), InsnComparator.WILDCARD, "(III)I"));
        targetNodeAfter = ASMHelper.findPreviousLabelOrLineNumber(targetNodeAfter).getNext();
        InsnList toInjectAfter = new InsnList();
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(21, prevFoodLevel.index));
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(23, prevSaturationLevel.index));
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(25, 5));
        toInjectAfter.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "onPostBlockFoodEaten", "(Lnet/minecraft/block/Block;Lsqueek/applecore/api/food/FoodValues;IFLnet/minecraft/entity/player/EntityPlayer;)V"));
        method.instructions.insertBefore(targetNodeAfter, toInjectAfter);
    }
}

