/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelAxe;
import vazkii.botania.common.item.relic.ItemLokiRing;

public class ItemTerraAxe
extends ItemManasteelAxe
implements ISequentialBreaker {
    private static final int MANA_PER_DAMAGE = 100;
    private static Map<Integer, List<BlockSwapper>> blockSwappers = new HashMap<Integer, List<BlockSwapper>>();
    IIcon iconOn;
    IIcon iconOff;

    public ItemTerraAxe() {
        super(BotaniaAPI.terrasteelToolMaterial, "terraAxe");
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.iconOn = IconHelper.forItem(par1IconRegister, (Item)this, 0);
        this.iconOff = IconHelper.forItem(par1IconRegister, (Item)this, 1);
    }

    public IIcon func_77617_a(int p_77617_1_) {
        return this.iconOn;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.shouldBreak(player) ? this.iconOn : this.iconOff;
    }

    public boolean shouldBreak(EntityPlayer player) {
        return !player.func_70093_af() && !ItemTemperanceStone.hasTemperanceActive(player);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        MovingObjectPosition raycast = ToolCommons.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0);
        if (raycast != null) {
            this.breakOtherBlock(player, stack, x, y, z, x, y, z, raycast.field_72310_e);
            ItemLokiRing.breakOnAllCursors(player, (Item)this, stack, x, y, z, raycast.field_72310_e);
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(EntityPlayer player, ItemStack stack, int x, int y, int z, int originX, int originY, int originZ, int side) {
        if (this.shouldBreak(player)) {
            ChunkCoordinates coords = new ChunkCoordinates(x, y, z);
            ItemTerraAxe.addBlockSwapper(player.field_70170_p, player, stack, coords, coords, 32, false, true, new ArrayList<String>());
        }
    }

    @Override
    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.field_73011_w.field_76574_g)) {
            List<BlockSwapper> swappers = blockSwappers.get(dim);
            ArrayList<BlockSwapper> swappersSafe = new ArrayList<BlockSwapper>(swappers);
            swappers.clear();
            for (BlockSwapper s : swappersSafe) {
                if (s == null) continue;
                s.tick();
            }
        }
    }

    private static BlockSwapper addBlockSwapper(World world, EntityPlayer player, ItemStack stack, ChunkCoordinates origCoords, ChunkCoordinates coords, int steps, boolean leaves, boolean force, List<String> posChecked) {
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, coords, steps, leaves, force, posChecked);
        int dim = world.field_73011_w.field_76574_g;
        if (!blockSwappers.containsKey(dim)) {
            blockSwappers.put(dim, new ArrayList());
        }
        blockSwappers.get(dim).add(swapper);
        return swapper;
    }

    private static class BlockSwapper {
        final World world;
        final EntityPlayer player;
        final ItemStack stack;
        final ChunkCoordinates origCoords;
        final int steps;
        final ChunkCoordinates coords;
        final boolean leaves;
        final boolean force;
        final List<String> posChecked;

        BlockSwapper(World world, EntityPlayer player, ItemStack stack, ChunkCoordinates origCoords, ChunkCoordinates coords, int steps, boolean leaves, boolean force, List<String> posChecked) {
            this.world = world;
            this.player = player;
            this.stack = stack;
            this.origCoords = origCoords;
            this.coords = coords;
            this.steps = steps;
            this.leaves = leaves;
            this.force = force;
            this.posChecked = posChecked;
        }

        void tick() {
            Block blockat = this.world.func_147439_a(this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c);
            if (!this.force && blockat.isAir((IBlockAccess)this.world, this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c)) {
                return;
            }
            ToolCommons.removeBlockWithDrops(this.player, this.stack, this.world, this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c, this.origCoords.field_71574_a, this.origCoords.field_71572_b, this.origCoords.field_71573_c, null, ToolCommons.materialsAxe, EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)this.stack) > 0, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.stack), 0.0f, false, !this.leaves);
            if (this.steps == 0) {
                return;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int x = this.coords.field_71574_a + dir.offsetX;
                int y = this.coords.field_71572_b + dir.offsetY;
                int z = this.coords.field_71573_c + dir.offsetZ;
                String pstr = this.posStr(x, y, z);
                if (this.posChecked.contains(pstr)) continue;
                Block block = this.world.func_147439_a(x, y, z);
                boolean log = block.isWood((IBlockAccess)this.world, x, y, z);
                boolean leaf = block.isLeaves((IBlockAccess)this.world, x, y, z);
                if (!log && !leaf) continue;
                int steps = this.steps - 1;
                steps = leaf ? (this.leaves ? steps : 3) : steps;
                ItemTerraAxe.addBlockSwapper(this.world, this.player, this.stack, this.origCoords, new ChunkCoordinates(x, y, z), steps, leaf, false, this.posChecked);
                this.posChecked.add(pstr);
            }
        }

        String posStr(int x, int y, int z) {
            return x + ":" + y + ":" + z;
        }
    }
}

