/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.customConversions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.emc.mappers.customConversions.json.ConversionGroup;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversionDeserializer;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversionFile;
import moze_intel.projecte.emc.mappers.customConversions.json.FixedValues;
import moze_intel.projecte.emc.mappers.customConversions.json.FixedValuesDeserializer;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.IOUtils;

public class CustomConversionMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    public static final ImmutableList<String> defaultfilenames = ImmutableList.of((Object)"metals", (Object)"example", (Object)"ODdefaults");

    @Override
    public String getName() {
        return "CustomConversionMapper";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        File customConversionFolder = CustomConversionMapper.getCustomConversionFolder();
        if (customConversionFolder.isDirectory() || customConversionFolder.mkdir()) {
            if (config.getBoolean("writeDefaultFiles", "", true, "Create the default files if they are not present, yet. Will not overwrite them, only create them when they are not present.")) {
                CustomConversionMapper.tryToWriteDefaultFiles();
            }
            for (File f : customConversionFolder.listFiles()) {
                if (!f.isFile() || !f.canRead() || !f.getName().toLowerCase().endsWith(".json") || !config.getBoolean(f.getName().substring(0, f.getName().length() - 5), "", true, String.format("Read file: %s?", f.getName()))) continue;
                try {
                    CustomConversionMapper.addMappingsFromFile(new FileReader(f), mapper);
                    PELogger.logInfo("Collected Mappings from " + f.getName());
                }
                catch (Exception e) {
                    PELogger.logFatal("Exception when reading file: " + f);
                    e.printStackTrace();
                }
            }
        } else {
            PELogger.logFatal("COULD NOT CREATE customConversions FOLDER IN config/ProjectE");
        }
    }

    public static File getCustomConversionFolder() {
        return new File(PECore.CONFIG_DIR, "customConversions");
    }

    public static void addMappingsFromFile(Reader json, IMappingCollector<NormalizedSimpleStack, Integer> mapper) {
        CustomConversionMapper.addMappingsFromFile(CustomConversionMapper.parseJson(json), mapper);
    }

    public static void addMappingsFromFile(CustomConversionFile file, IMappingCollector<NormalizedSimpleStack, Integer> mapper) {
        HashMap fakes = Maps.newHashMap();
        for (Map.Entry<String, ConversionGroup> entry : file.groups.entrySet()) {
            PELogger.logDebug(String.format("Adding conversions from group '%s' with comment '%s'", entry.getKey(), entry.getValue().comment));
            try {
                for (CustomConversion conversion : entry.getValue().conversions) {
                    NormalizedSimpleStack output = CustomConversionMapper.getNSSfromJsonString(conversion.output, fakes);
                    mapper.addConversion(conversion.count, output, CustomConversionMapper.convertToNSSMap(conversion.ingredients, fakes));
                }
            }
            catch (Exception e) {
                PELogger.logFatal(String.format("ERROR reading custom conversion from group %s!", entry.getKey()));
                e.printStackTrace();
            }
        }
        try {
            if (file.values != null) {
                String odName;
                NormalizedSimpleStack something;
                if (file.values.setValueBefore != null) {
                    for (Map.Entry<String, Object> entry : file.values.setValueBefore.entrySet()) {
                        something = CustomConversionMapper.getNSSfromJsonString(entry.getKey(), fakes);
                        mapper.setValueBefore(something, (Integer)((Comparable)entry.getValue()));
                        if (!(something instanceof NormalizedSimpleStack.NSSOreDictionary)) continue;
                        odName = ((NormalizedSimpleStack.NSSOreDictionary)something).od;
                        for (ItemStack itemStack : OreDictionary.getOres((String)odName)) {
                            mapper.setValueBefore(NormalizedSimpleStack.getFor(itemStack), (Integer)((Comparable)entry.getValue()));
                        }
                    }
                }
                if (file.values.setValueAfter != null) {
                    for (Map.Entry entry : file.values.setValueAfter.entrySet()) {
                        something = CustomConversionMapper.getNSSfromJsonString((String)entry.getKey(), fakes);
                        mapper.setValueAfter(something, (Integer)((Comparable)entry.getValue()));
                        if (!(something instanceof NormalizedSimpleStack.NSSOreDictionary)) continue;
                        odName = ((NormalizedSimpleStack.NSSOreDictionary)something).od;
                        for (ItemStack itemStack : OreDictionary.getOres((String)odName)) {
                            mapper.setValueAfter(NormalizedSimpleStack.getFor(itemStack), (Integer)((Comparable)entry.getValue()));
                        }
                    }
                }
                if (file.values.conversion != null) {
                    for (CustomConversion customConversion : file.values.conversion) {
                        NormalizedSimpleStack out = CustomConversionMapper.getNSSfromJsonString(customConversion.output, fakes);
                        if (customConversion.evalOD && out instanceof NormalizedSimpleStack.NSSOreDictionary) {
                            odName = ((NormalizedSimpleStack.NSSOreDictionary)out).od;
                            for (ItemStack itemStack : OreDictionary.getOres((String)odName)) {
                                mapper.setValueFromConversion(customConversion.count, NormalizedSimpleStack.getFor(itemStack), CustomConversionMapper.convertToNSSMap(customConversion.ingredients, fakes));
                            }
                        }
                        mapper.setValueFromConversion(customConversion.count, out, CustomConversionMapper.convertToNSSMap(customConversion.ingredients, fakes));
                    }
                }
            }
        }
        catch (Exception e) {
            PELogger.logFatal("ERROR reading custom conversion values!");
            e.printStackTrace();
        }
    }

    private static NormalizedSimpleStack getNSSfromJsonString(String s, Map<String, NormalizedSimpleStack> fakes) throws Exception {
        if (s.startsWith("OD|")) {
            return NormalizedSimpleStack.forOreDictionary(s.substring(3));
        }
        if (s.startsWith("FAKE|")) {
            String fakeIdentifier = s.substring(5);
            if (fakes.containsKey(fakeIdentifier)) {
                return fakes.get(fakeIdentifier);
            }
            NormalizedSimpleStack nssFake = NormalizedSimpleStack.createFake(fakeIdentifier);
            fakes.put(fakeIdentifier, nssFake);
            return nssFake;
        }
        if (s.startsWith("FLUID|")) {
            String fluidName = s.substring("FLUID|".length());
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid == null) {
                return null;
            }
            return NormalizedSimpleStack.getFor(fluid);
        }
        return NormalizedSimpleStack.fromSerializedItem(s);
    }

    private static <V> Map<NormalizedSimpleStack, V> convertToNSSMap(Map<String, V> m, Map<String, NormalizedSimpleStack> fakes) throws Exception {
        HashMap out = Maps.newHashMap();
        for (Map.Entry<String, V> e : m.entrySet()) {
            NormalizedSimpleStack nssItem = CustomConversionMapper.getNSSfromJsonString(e.getKey(), fakes);
            out.put(nssItem, e.getValue());
        }
        return out;
    }

    public static CustomConversionFile parseJson(Reader json) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(CustomConversion.class, (Object)new CustomConversionDeserializer());
        builder.registerTypeAdapter(FixedValues.class, (Object)new FixedValuesDeserializer());
        Gson gson = builder.create();
        return (CustomConversionFile)gson.fromJson(json, CustomConversionFile.class);
    }

    public static void tryToWriteDefaultFiles() {
        for (String filename : defaultfilenames) {
            CustomConversionMapper.writeDefaultFile(filename);
        }
    }

    private static void writeDefaultFile(String filename) {
        File customConversionFolder = CustomConversionMapper.getCustomConversionFolder();
        File f = new File(customConversionFolder, filename + ".json");
        if (f.exists()) {
            return;
        }
        try {
            if (f.createNewFile() && f.canWrite()) {
                InputStream stream = CustomConversionMapper.class.getClassLoader().getResourceAsStream("defaultCustomConversions/" + filename + ".json");
                FileOutputStream outputStream = new FileOutputStream(f);
                IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
                stream.close();
                ((OutputStream)outputStream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

