/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import moze_intel.projecte.gameObjs.ObjHandler;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipesCovalenceRepair
implements IRecipe {
    private ItemStack output;

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ItemStack[] dust = new ItemStack[8];
        ItemStack tool = null;
        boolean foundItem = false;
        int dustCounter = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack input = inv.func_70301_a(i);
            if (input == null) continue;
            if (this.isItemRepairable(input)) {
                if (!foundItem) {
                    tool = input;
                    foundItem = true;
                    continue;
                }
                return false;
            }
            if (input.func_77973_b() != ObjHandler.covalence) continue;
            if (dustCounter < 8) {
                dust[dustCounter] = input;
                ++dustCounter;
                continue;
            }
            return false;
        }
        if (tool == null || !foundItem || dustCounter == 0) {
            return false;
        }
        if (!this.correctDustCount(dustCounter, tool.func_77973_b())) {
            return false;
        }
        int dustDamage = this.getDustType(tool);
        for (int i = 0; i < dust.length; ++i) {
            ItemStack stack = dust[i];
            if (stack == null || stack.func_77960_j() >= dustDamage) continue;
            return false;
        }
        this.output = tool.func_77946_l();
        this.output.func_77964_b(0);
        return true;
    }

    private boolean correctDustCount(int dustCounter, Item toRepair) {
        if (toRepair instanceof ItemSpade || toRepair instanceof ItemShears || toRepair instanceof ItemFlintAndSteel || toRepair instanceof ItemFishingRod) {
            return dustCounter == 1;
        }
        if (toRepair instanceof ItemSword) {
            return dustCounter == 2;
        }
        if (toRepair instanceof ItemAxe || toRepair instanceof ItemPickaxe || toRepair instanceof ItemBow) {
            return dustCounter == 3;
        }
        if (toRepair instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)toRepair;
            switch (armor.field_77881_a) {
                case 0: {
                    return dustCounter == 5;
                }
                case 1: {
                    return dustCounter == 8;
                }
                case 2: {
                    return dustCounter == 7;
                }
                case 3: {
                    return dustCounter == 4;
                }
            }
            return false;
        }
        return dustCounter == 3;
    }

    private boolean isItemRepairable(ItemStack stack) {
        if (stack.func_77981_g()) {
            return false;
        }
        if (stack.func_77958_k() == 0 || stack.func_77960_j() == 0) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemShears || item instanceof ItemFlintAndSteel || item instanceof ItemFishingRod || item instanceof ItemBow) {
            return true;
        }
        return item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemHoe || item instanceof ItemArmor;
    }

    private int getDustType(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemShears || item instanceof ItemFlintAndSteel) {
            return 1;
        }
        if (item instanceof ItemBow || item instanceof ItemFishingRod) {
            return 0;
        }
        String name = "";
        if (item instanceof ItemTool) {
            name = ((ItemTool)item).func_77861_e();
        } else if (item instanceof ItemSword) {
            name = ((ItemSword)item).func_150932_j();
        } else if (item instanceof ItemHoe) {
            name = ((ItemHoe)item).func_77842_f();
        } else if (item instanceof ItemArmor) {
            name = ((ItemArmor)item).func_82812_d().toString();
        }
        if (name.equals("WOOD") || name.equals("STONE") || name.equals("CLOTH")) {
            return 0;
        }
        if (name.equals("IRON") || name.equals("GOLD") || name.equals("CHAIN")) {
            return 1;
        }
        return 2;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return 10;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }
}

