/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.playerData;

import com.google.common.collect.Maps;
import java.util.Map;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.SyncBagDataPKT;
import moze_intel.projecte.playerData.AlchBagProps;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class AlchemicalBags {
    @Deprecated
    private static Map<String, Map<Byte, ItemStack[]>> MAP = Maps.newLinkedHashMap();

    public static ItemStack[] get(EntityPlayer player, byte color) {
        return AlchBagProps.getDataFor(player).getInv(color);
    }

    public static void set(EntityPlayer player, byte color, ItemStack[] inv) {
        AlchBagProps.getDataFor(player).setInv(color, inv);
    }

    public static void syncFull(EntityPlayer player) {
        PacketHandler.sendTo(new SyncBagDataPKT(AlchBagProps.getDataFor(player).saveForPacket()), (EntityPlayerMP)player);
        PELogger.logDebug("** SENT FULL BAG DATA **");
    }

    public static void syncPartial(EntityPlayer player, int color) {
        PacketHandler.sendTo(new SyncBagDataPKT(AlchBagProps.getDataFor(player).saveForPartialPacket(color)), (EntityPlayerMP)player);
        PELogger.logDebug("** SENT PARTIAL BAG DATA **");
    }

    public static boolean hasLegacyData(EntityPlayer player) {
        return MAP.containsKey(player.func_70005_c_());
    }

    public static NBTTagList migratePlayerData(EntityPlayer player) {
        Map<Byte, ItemStack[]> data = MAP.get(player.func_70005_c_());
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Byte, ItemStack[]> entry : data.entrySet()) {
            NBTTagCompound subNbt = new NBTTagCompound();
            subNbt.func_74768_a("color", (int)entry.getKey().byteValue());
            NBTTagList subList = new NBTTagList();
            ItemStack[] inv = entry.getValue();
            for (int i = 0; i < inv.length; ++i) {
                ItemStack stack = inv[i];
                if (stack == null) continue;
                NBTTagCompound subNbt2 = new NBTTagCompound();
                subNbt2.func_74774_a("index", (byte)i);
                stack.func_77955_b(subNbt2);
                subList.func_74742_a((NBTBase)subNbt2);
            }
            subNbt.func_74782_a("inv", (NBTBase)subList);
            list.func_74742_a((NBTBase)subNbt);
        }
        return list;
    }

    @Deprecated
    public static void legacySet(String player, byte bagColour, ItemStack[] inv) {
        Map<Object, Object> setdata;
        if (MAP.containsKey(player)) {
            setdata = MAP.get(player);
        } else {
            setdata = Maps.newLinkedHashMap();
            MAP.put(player, (Map<Byte, ItemStack[]>)setdata);
        }
        if (setdata == null) {
            setdata = Maps.newLinkedHashMap();
            MAP.put(player, setdata);
        }
        setdata.put(bagColour, inv);
    }
}

