/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.core.util.vector.Vector3f;
import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.ingameinfo.client.gui.Info;
import com.github.lunatrius.ingameinfo.tag.TagNearbyPlayer;
import com.github.lunatrius.ingameinfo.tag.TagPlayerPotion;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public abstract class Tag {
    protected static final Minecraft minecraft = Minecraft.func_71410_x();
    protected static final Vector3i playerPosition = new Vector3i();
    protected static final Vector3f playerMotion = new Vector3f();
    protected static MinecraftServer server;
    protected static World world;
    protected static EntityClientPlayerMP player;
    protected static List<Info> info;
    protected static boolean hasSeed;
    protected static long seed;
    private String name = null;
    private String[] aliases = new String[0];

    public Tag setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Tag setAliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean isIndexed() {
        return false;
    }

    public int getMaximumIndex() {
        return -1;
    }

    public String getRawName() {
        return this.name;
    }

    public String getFormattedName() {
        return this.name + (this.isIndexed() ? String.format("[0..%d]", this.getMaximumIndex()) : "");
    }

    public String getLocalizedCategory() {
        return I18n.func_135052_a((String)("InGameInfoXML".toLowerCase() + ".tag.category." + this.getCategory() + ".name"), (Object[])new Object[0]);
    }

    public String getLocalizedDescription() {
        return I18n.func_135052_a((String)("InGameInfoXML".toLowerCase() + ".tag." + this.getRawName() + ".desc"), (Object[])new Object[0]);
    }

    public abstract String getCategory();

    public abstract String getValue();

    public static void setServer(MinecraftServer server) {
        Tag.server = server;
        try {
            Tag.setSeed(Tag.server.func_71218_a(0).func_72905_C());
        }
        catch (Exception e) {
            Tag.unsetSeed();
        }
    }

    public static void setSeed(long seed) {
        hasSeed = true;
        Tag.seed = seed;
    }

    public static void unsetSeed() {
        hasSeed = false;
        seed = 0L;
    }

    public static void setWorld(World world) {
        Tag.world = world;
    }

    public static void setPlayer(EntityClientPlayerMP player) {
        Tag.player = player;
        if (player != null) {
            playerPosition.set((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
            playerMotion.set((float)(player.field_70165_t - player.field_70169_q), (float)(player.field_70163_u - player.field_70167_r), (float)(player.field_70161_v - player.field_70166_s));
        }
    }

    public static void setInfo(List<Info> info) {
        Tag.info = info;
    }

    public static void releaseResources() {
        Tag.setWorld(null);
        Tag.setPlayer(null);
        TagNearbyPlayer.releaseResources();
        TagPlayerPotion.releaseResources();
    }

    public static String getIconTag(Info info) {
        String str = "";
        for (int i = 0; i < info.getWidth() && Tag.minecraft.field_71466_p.func_78256_a(str) < info.getWidth(); ++i) {
            str = str + " ";
        }
        return String.format("{ICON|%s}", str);
    }

    static {
        hasSeed = false;
        seed = 0L;
    }
}

